/*
 * Decompiled with CFR 0.152.
 */
package org.measureyourgradient;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.help.HelpSet;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.measureyourgradient.AutoScaleEvent;
import org.measureyourgradient.AutoScaleListener;
import org.measureyourgradient.Compound;
import org.measureyourgradient.Globals;
import org.measureyourgradient.InterpolationFunction;
import org.measureyourgradient.LinearInterpolationFunction;
import org.measureyourgradient.PreloadedValuesDialog;
import org.measureyourgradient.TopPanel;
import org.measureyourgradient.TopPanel2;

public class MeasureYourGradientApplet
extends JApplet
implements ActionListener,
KeyListener,
FocusListener,
ListSelectionListener,
AutoScaleListener,
TableModelListener,
ClipboardOwner {
    private static final long serialVersionUID = 1L;
    TopPanel contentPane = null;
    TopPanel2 contentPane2 = null;
    public JScrollPane jMainScrollPane = null;
    public JPanel jBackPanel = null;
    public int m_iStationaryPhase = 0;
    public double m_dColumnLength = 100.0;
    public double m_dColumnInnerDiameter = 2.1;
    public double m_dProgramTime = 20.0;
    public double m_dFlowRate = 1.0;
    public int m_iNumPoints = 3000;
    public Vector<Object[]> m_vectCalCompounds = new Vector();
    private Task task = null;
    public int m_iStage = 1;
    public double m_dtstep = 0.01;
    public double m_V0 = 1.0;
    public double[][] m_dDeadVolumeArray;
    public double[][] m_dIdealGradientProfileArray;
    public LinearInterpolationFunction m_InterpolatedIdealGradientProfile;
    public InterpolationFunction m_InterpolatedGradientProfile;
    public InterpolationFunction m_InitialInterpolatedFlowRatevsTimeProfile;
    public double[][] m_dGradientProfileArray;
    public double[][] m_dFlowRateArray;
    public InterpolationFunction m_InterpolatedFlowRate;
    public InterpolationFunction[] m_StandardIsocraticDataInterpolated;
    public InterpolationFunction m_Vm;
    public double[][][] m_dFlowRateArrayStore;
    public double[][][] m_dGradientArrayStore;
    public double[] m_dRetentionErrorStore;
    public int m_iInterpolatedGradientProgramSeries = 0;
    public int m_iGradientProgramMarkerSeries = 0;
    public int m_iInterpolatedFlowRateSeries = 0;
    public int m_iFlowRateMarkerSeries = 0;
    public double m_dPlotXMax = 0.0;
    public double m_dPlotXMax2 = 0.0;
    public boolean m_bDoNotChangeTable = false;
    public final double m_dGoldenRatio = (1.0 + Math.sqrt(5.0)) / 2.0;
    public Vector<Compound> m_vectCompound = new Vector();

    public MeasureYourGradientApplet() {
        this.setPreferredSize(new Dimension(943, 615));
    }

    @Override
    public void init() {
        String helpHS = "org/measureyourgradient/help/RetentionPredictorHelp.hs";
        ClassLoader cl = TopPanel.class.getClassLoader();
        try {
            URL hsURL = HelpSet.findHelpSet((ClassLoader)cl, (String)helpHS);
            Globals.hsMainHelpSet = new HelpSet(null, hsURL);
        }
        catch (Exception ee) {
            System.out.println("HelpSet " + ee.getMessage());
            System.out.println("HelpSet " + helpHS + " not found");
            return;
        }
        Globals.hbMainHelpBroker = Globals.hsMainHelpSet.createHelpBroker();
        try {
            this.createGUI();
        }
        catch (Exception e) {
            System.err.println("createGUI didn't complete successfully");
            System.err.println(e.getMessage());
            System.err.println(e.getLocalizedMessage());
            System.err.println(e.toString());
            System.err.println(e.getStackTrace());
            System.err.println(e.getCause());
        }
        this.performValidations();
    }

    private void createGUI() {
        this.jMainScrollPane = new JScrollPane();
        this.jMainScrollPane.setHorizontalScrollBarPolicy(30);
        this.jMainScrollPane.setVerticalScrollBarPolicy(20);
        this.contentPane = new TopPanel();
        this.contentPane.setOpaque(true);
        this.jMainScrollPane.setViewportView(this.contentPane);
        this.setContentPane(this.jMainScrollPane);
        this.jMainScrollPane.revalidate();
        this.contentPane.jtxtColumnLength.addFocusListener(this);
        this.contentPane.jtxtColumnLength.addKeyListener(this);
        this.contentPane.jtxtInnerDiameter.addFocusListener(this);
        this.contentPane.jtxtInnerDiameter.addKeyListener(this);
        this.contentPane.jtxtFlowRate.addFocusListener(this);
        this.contentPane.jtxtFlowRate.addKeyListener(this);
        this.contentPane.jbtnHelp.addActionListener(this);
        this.contentPane.jbtnInsertRow.addActionListener(this);
        this.contentPane.jbtnRemoveRow.addActionListener(this);
        this.contentPane.m_GraphControlGradient.addAutoScaleListener(this);
        this.contentPane.m_GraphControlFlowRate.addAutoScaleListener(this);
        this.contentPane.tmGradientProgram.addTableModelListener(this);
        this.contentPane.tmMeasuredRetentionTimes.addTableModelListener(this);
        this.contentPane.jbtnNextStep.addActionListener(this);
        this.contentPane.jbtnPreloadedValues.addActionListener(this);
        this.contentPane.m_GraphControlGradient.setYAxisTitle("Eluent Composition (%B)");
        this.contentPane.m_GraphControlGradient.setYAxisBaseUnit("", "");
        this.contentPane.m_GraphControlGradient.setYAxisRangeLimits(0.0, 105.0);
        this.contentPane.m_GraphControlGradient.setYAxisRangeIndicatorsVisible(false);
        this.contentPane.m_GraphControlGradient.setXAxisRangeIndicatorsVisible(false);
        this.contentPane.m_GraphControlGradient.setAutoScaleY(true);
        this.contentPane.m_GraphControlGradient.repaint();
        this.contentPane.m_GraphControlFlowRate.setYAxisTitle("Flow Rate");
        this.contentPane.m_GraphControlFlowRate.setYAxisBaseUnit("liter/min", "L/min");
        this.contentPane.m_GraphControlFlowRate.setYAxisRangeLimits(0.0, 10000.0);
        this.contentPane.m_GraphControlFlowRate.setYAxisRangeIndicatorsVisible(false);
        this.contentPane.m_GraphControlFlowRate.setXAxisRangeIndicatorsVisible(false);
        this.contentPane.m_GraphControlFlowRate.setAutoScaleY(true);
        this.contentPane.m_GraphControlFlowRate.repaint();
        this.contentPane2 = new TopPanel2();
        this.contentPane2.setOpaque(true);
        this.contentPane2.jbtnCalculate.addActionListener(this);
        this.contentPane2.jbtnPreviousStep.addActionListener(this);
        this.contentPane2.jbtnHelp.addActionListener(this);
        this.contentPane2.m_GraphControlGradient.setYAxisTitle("Eluent Composition (%B)");
        this.contentPane2.m_GraphControlGradient.setYAxisBaseUnit("", "");
        this.contentPane2.m_GraphControlGradient.setYAxisRangeLimits(0.0, 105.0);
        this.contentPane2.m_GraphControlGradient.setYAxisRangeIndicatorsVisible(false);
        this.contentPane2.m_GraphControlGradient.setXAxisRangeIndicatorsVisible(false);
        this.contentPane2.m_GraphControlGradient.setAutoScaleY(true);
        this.contentPane2.m_GraphControlGradient.repaint();
        this.contentPane2.m_GraphControlFlowRate.setYAxisTitle("Flow Rate (mL/min)");
        this.contentPane2.m_GraphControlFlowRate.setYAxisBaseUnit("liter/min", "L/min");
        this.contentPane2.m_GraphControlFlowRate.setYAxisRangeLimits(0.0, 100.0);
        this.contentPane2.m_GraphControlFlowRate.setYAxisRangeIndicatorsVisible(true);
        this.contentPane2.m_GraphControlFlowRate.setAutoScaleY(true);
        this.contentPane2.m_GraphControlFlowRate.setXAxisRangeIndicatorsVisible(false);
        this.contentPane2.m_GraphControlFlowRate.repaint();
    }

    private void validateColumnLength() {
        double dTemp;
        if (this.contentPane.jtxtColumnLength.getText() == null) {
            this.contentPane.jtxtColumnLength.setText("0");
        }
        if ((dTemp = (double)Float.valueOf(this.contentPane.jtxtColumnLength.getText()).floatValue()) < 0.1) {
            dTemp = 0.1;
        }
        if (dTemp > 10000.0) {
            dTemp = 10000.0;
        }
        this.m_dColumnLength = dTemp;
        this.contentPane.jtxtColumnLength.setText(Float.toString((float)this.m_dColumnLength));
    }

    private void validateColumnInnerDiameter() {
        double dTemp;
        if (this.contentPane.jtxtInnerDiameter.getText() == null) {
            this.contentPane.jtxtInnerDiameter.setText("0");
        }
        if ((dTemp = (double)Float.valueOf(this.contentPane.jtxtInnerDiameter.getText()).floatValue()) < 0.01) {
            dTemp = 0.01;
        }
        if (dTemp > 10000.0) {
            dTemp = 10000.0;
        }
        this.m_dColumnInnerDiameter = dTemp;
        this.contentPane.jtxtInnerDiameter.setText(Float.toString((float)this.m_dColumnInnerDiameter));
    }

    private void validateFlowRate() {
        double dTemp;
        if (this.contentPane.jtxtFlowRate.getText() == null) {
            this.contentPane.jtxtFlowRate.setText("0");
        }
        if ((dTemp = (double)Float.valueOf(this.contentPane.jtxtFlowRate.getText()).floatValue()) < 1.0E-9) {
            dTemp = 1.0E-9;
        }
        if (dTemp > 10000.0) {
            dTemp = 10000.0;
        }
        this.m_dFlowRate = dTemp;
        this.contentPane.jtxtFlowRate.setText(Float.toString((float)this.m_dFlowRate));
    }

    public void nextStepButtonPressed() {
        int iNumGradientProgramDataPoints;
        this.m_iStage = 2;
        this.contentPane2.jbtnCalculate.setText("Back-Calculate Profiles");
        this.contentPane2.jbtnCalculate.setEnabled(true);
        this.contentPane2.jbtnCalculate.setActionCommand("Calculate");
        this.contentPane2.jlblIterationNumber.setText("1");
        this.contentPane2.jlblLastVariance.setText("");
        this.contentPane2.jlblPercentImprovement.setText("");
        this.contentPane2.jlblPhase.setText("I");
        this.contentPane2.jlblTimeElapsed.setText("");
        this.contentPane2.jlblVariance.setText("");
        this.contentPane2.jProgressBar.setString("");
        this.contentPane2.jProgressBar.setIndeterminate(false);
        this.contentPane2.m_GraphControlGradient.RemoveAllSeries();
        this.contentPane2.m_GraphControlFlowRate.RemoveAllSeries();
        this.contentPane2.jpanelStep5.setVisible(true);
        this.m_dDeadVolumeArray = new double[Globals.dDeadVolumeArray.length][2];
        int i = 0;
        while (i < Globals.dDeadVolumeArray.length) {
            double dVolumeInRefColumn = Math.PI * Math.pow(0.21, 2.0) * 10.0;
            double dDeadVolPerVol = Globals.dDeadVolumeArray[i][1] / dVolumeInRefColumn;
            double dNewDeadVol = dDeadVolPerVol * Math.PI * Math.pow(this.m_dColumnInnerDiameter / 10.0, 2.0) * this.m_dColumnLength / 10.0;
            this.m_dDeadVolumeArray[i][0] = Globals.dDeadVolumeArray[i][0];
            this.m_dDeadVolumeArray[i][1] = dNewDeadVol;
            ++i;
        }
        double dVmMax = 0.0;
        int i2 = 0;
        while (i2 < this.m_dDeadVolumeArray.length) {
            if (this.m_dDeadVolumeArray[i2][1] > dVmMax) {
                dVmMax = this.m_dDeadVolumeArray[i2][1];
            }
            ++i2;
        }
        this.contentPane2.tmOutputModel.getDataVector().clear();
        this.m_vectCalCompounds.clear();
        i2 = 0;
        while (i2 < this.contentPane.tmMeasuredRetentionTimes.getRowCount()) {
            if (!((Double)this.contentPane.tmMeasuredRetentionTimes.getValueAt(i2, 3) <= Double.valueOf(0.0)) && ((Boolean)this.contentPane.tmMeasuredRetentionTimes.getValueAt(i2, 0)).booleanValue()) {
                Object[] objectArray = new Object[4];
                objectArray[0] = this.contentPane.tmMeasuredRetentionTimes.getValueAt(i2, 1);
                objectArray[1] = this.contentPane.tmMeasuredRetentionTimes.getValueAt(i2, 3);
                Object[] newRow = objectArray;
                this.contentPane2.tmOutputModel.addRow(newRow);
                Object[] newSolute = new Object[]{i2, this.contentPane.tmMeasuredRetentionTimes.getValueAt(i2, 3), 0.0};
                this.m_vectCalCompounds.add(newSolute);
            }
            ++i2;
        }
        Collections.sort(this.m_vectCalCompounds, new CompoundSorter(1));
        this.m_dPlotXMax2 = (Double)this.m_vectCalCompounds.get(this.m_vectCalCompounds.size() - 1)[1] - 0.5 * (dVmMax / this.m_dFlowRate);
        this.m_dtstep = this.m_dPlotXMax2 * 0.001;
        int iIdealPlotIndexGradient = this.contentPane2.m_GraphControlGradient.AddSeries("Ideal Gradient Program", new Color(0, 0, 0), 1, false, false);
        int iIdealPlotIndexFlowRate = this.contentPane2.m_GraphControlFlowRate.AddSeries("Ideal Flow Rate", new Color(0, 0, 0), 1, false, false);
        this.m_iInterpolatedGradientProgramSeries = this.contentPane2.m_GraphControlGradient.AddSeries("Interpolated Gradient Program", new Color(255, 0, 0), 1, false, false);
        this.m_iGradientProgramMarkerSeries = this.contentPane2.m_GraphControlGradient.AddSeries("Gradient Program Markers", new Color(255, 0, 0), 1, true, false);
        this.m_iInterpolatedFlowRateSeries = this.contentPane2.m_GraphControlFlowRate.AddSeries("Interpolated Flow Rate", new Color(255, 0, 0), 1, false, false);
        this.m_iFlowRateMarkerSeries = this.contentPane2.m_GraphControlFlowRate.AddSeries("Flow Rate Markers", new Color(255, 0, 0), 1, true, false);
        this.m_dIdealGradientProfileArray = new double[this.contentPane.tmGradientProgram.getRowCount() + 2][2];
        int iPointCount = 0;
        this.contentPane2.m_GraphControlGradient.AddDataPoint(iIdealPlotIndexGradient, 0.0, (Double)this.contentPane.tmGradientProgram.getValueAt(0, 1));
        this.m_dIdealGradientProfileArray[iPointCount][0] = 0.0;
        this.m_dIdealGradientProfileArray[iPointCount][1] = (Double)this.contentPane.tmGradientProgram.getValueAt(0, 1);
        double dLastTime = 0.0;
        ++iPointCount;
        int i3 = 0;
        while (i3 < this.contentPane.tmGradientProgram.getRowCount()) {
            if ((Double)this.contentPane.tmGradientProgram.getValueAt(i3, 0) > dLastTime) {
                double dTime = (Double)this.contentPane.tmGradientProgram.getValueAt(i3, 0);
                double dFractionB = (Double)this.contentPane.tmGradientProgram.getValueAt(i3, 1);
                this.contentPane2.m_GraphControlGradient.AddDataPoint(iIdealPlotIndexGradient, dTime * 60.0, dFractionB);
                this.m_dIdealGradientProfileArray[iPointCount][0] = dTime;
                this.m_dIdealGradientProfileArray[iPointCount][1] = dFractionB;
                ++iPointCount;
                dLastTime = dTime;
            }
            ++i3;
        }
        this.contentPane2.m_GraphControlGradient.AddDataPoint(iIdealPlotIndexGradient, this.m_dPlotXMax2 * 60.0, (Double)this.contentPane.tmGradientProgram.getValueAt(this.contentPane.tmGradientProgram.getRowCount() - 1, 1));
        this.m_dIdealGradientProfileArray[iPointCount][0] = this.m_dPlotXMax2 * 60.0;
        this.m_dIdealGradientProfileArray[iPointCount][1] = (Double)this.contentPane.tmGradientProgram.getValueAt(this.contentPane.tmGradientProgram.getRowCount() - 1, 1);
        double[][] tempArray = new double[++iPointCount][2];
        int i4 = 0;
        while (i4 < iPointCount) {
            tempArray[i4][0] = this.m_dIdealGradientProfileArray[i4][0];
            tempArray[i4][1] = this.m_dIdealGradientProfileArray[i4][1];
            ++i4;
        }
        this.m_dIdealGradientProfileArray = tempArray;
        this.m_InterpolatedIdealGradientProfile = new LinearInterpolationFunction(this.m_dIdealGradientProfileArray);
        int iTotalDataPoints = this.m_vectCalCompounds.size();
        int iNumFlowDataPoints = iTotalDataPoints - (iNumGradientProgramDataPoints = (int)(0.7333333333333333 * (double)iTotalDataPoints));
        if (iNumFlowDataPoints < 3) {
            iNumFlowDataPoints = 3;
            iNumGradientProgramDataPoints = iTotalDataPoints - iNumFlowDataPoints;
        }
        this.m_dGradientProfileArray = new double[iNumGradientProgramDataPoints][2];
        this.m_dFlowRateArray = new double[iNumFlowDataPoints][2];
        this.m_dGradientProfileArray[0][0] = 0.0;
        this.m_dGradientProfileArray[0][1] = this.m_InterpolatedIdealGradientProfile.getAt(this.m_dGradientProfileArray[0][0]);
        int i5 = 1;
        while (i5 < iNumGradientProgramDataPoints - 1) {
            double dStandardNum = (double)i5 / ((double)iNumGradientProgramDataPoints - 1.0) * (double)iTotalDataPoints;
            double dOneGreater = (int)Math.ceil(dStandardNum);
            double dOneLesser = (int)Math.floor(dStandardNum);
            double dRtOneLesser = (Double)this.m_vectCalCompounds.get((int)dOneLesser)[1];
            double dRtOneGreater = (Double)this.m_vectCalCompounds.get((int)dOneGreater)[1];
            if (dOneGreater == dOneLesser) {
                this.m_dGradientProfileArray[i5][0] = dRtOneLesser;
            } else {
                double dPosition = (dStandardNum - dOneLesser) / (dOneGreater - dOneLesser);
                this.m_dGradientProfileArray[i5][0] = dPosition * dRtOneGreater + (1.0 - dPosition) * dRtOneLesser;
            }
            this.m_dGradientProfileArray[i5][0] = this.m_dGradientProfileArray[i5][0] - 0.5 * (dVmMax / this.m_dFlowRate);
            this.m_dGradientProfileArray[i5][1] = this.m_InterpolatedIdealGradientProfile.getAt(this.m_dGradientProfileArray[i5][0]);
            ++i5;
        }
        this.m_dGradientProfileArray[iNumGradientProgramDataPoints - 1][0] = (Double)this.m_vectCalCompounds.get(this.m_vectCalCompounds.size() - 1)[1] - 0.5 * (dVmMax / this.m_dFlowRate);
        this.m_dGradientProfileArray[iNumGradientProgramDataPoints - 1][1] = this.m_InterpolatedIdealGradientProfile.getAt(this.m_dGradientProfileArray[iNumGradientProgramDataPoints - 1][0]);
        int iPointIndex = 1;
        int i6 = 1;
        while (i6 < this.m_dIdealGradientProfileArray.length - 1) {
            double dDistNextAfter;
            double dScoreNext;
            double dDistFirstBefore;
            double dScoreFirst;
            double dFirst = 0.0;
            double dNext = 0.0;
            while (dNext < this.m_dIdealGradientProfileArray[i6][0] && iPointIndex < this.m_dGradientProfileArray.length - 1) {
                dFirst = this.m_dGradientProfileArray[iPointIndex][0];
                dNext = this.m_dGradientProfileArray[iPointIndex + 1][0];
                ++iPointIndex;
            }
            double dDistFirst = this.m_dIdealGradientProfileArray[i6][0] - dFirst;
            double dDistNext = dNext - this.m_dIdealGradientProfileArray[i6][0];
            if ((dScoreFirst = dDistFirst + (dDistFirstBefore = this.m_dGradientProfileArray[--iPointIndex][0] - this.m_dGradientProfileArray[iPointIndex - 1][0])) < (dScoreNext = dDistNext + (dDistNextAfter = iPointIndex + 2 < this.m_dGradientProfileArray.length ? this.m_dGradientProfileArray[iPointIndex + 2][0] - this.m_dGradientProfileArray[iPointIndex + 1][0] : 0.0))) {
                this.m_dGradientProfileArray[iPointIndex][0] = this.m_dIdealGradientProfileArray[i6][0];
                this.m_dGradientProfileArray[iPointIndex][1] = this.m_InterpolatedIdealGradientProfile.getAt(this.m_dGradientProfileArray[iPointIndex][0]);
                if (iPointIndex >= 2) {
                    this.m_dGradientProfileArray[iPointIndex - 1][0] = (this.m_dGradientProfileArray[iPointIndex - 2][0] + this.m_dGradientProfileArray[iPointIndex][0]) / 2.0;
                    this.m_dGradientProfileArray[iPointIndex - 1][1] = this.m_InterpolatedIdealGradientProfile.getAt(this.m_dGradientProfileArray[iPointIndex - 1][0]);
                }
                if (iPointIndex <= this.m_dGradientProfileArray.length - 3) {
                    this.m_dGradientProfileArray[iPointIndex + 1][0] = (this.m_dGradientProfileArray[iPointIndex][0] + this.m_dGradientProfileArray[iPointIndex + 2][0]) / 2.0;
                    this.m_dGradientProfileArray[iPointIndex + 1][1] = this.m_InterpolatedIdealGradientProfile.getAt(this.m_dGradientProfileArray[iPointIndex + 1][0]);
                }
            } else {
                this.m_dGradientProfileArray[iPointIndex + 1][0] = this.m_dIdealGradientProfileArray[i6][0];
                this.m_dGradientProfileArray[iPointIndex + 1][1] = this.m_InterpolatedIdealGradientProfile.getAt(this.m_dGradientProfileArray[iPointIndex + 1][0]);
                if (iPointIndex >= 1) {
                    this.m_dGradientProfileArray[iPointIndex][0] = (this.m_dGradientProfileArray[iPointIndex - 1][0] + this.m_dGradientProfileArray[iPointIndex + 1][0]) / 2.0;
                    this.m_dGradientProfileArray[iPointIndex][1] = this.m_InterpolatedIdealGradientProfile.getAt(this.m_dGradientProfileArray[iPointIndex][0]);
                }
                if (iPointIndex <= this.m_dGradientProfileArray.length - 4) {
                    this.m_dGradientProfileArray[iPointIndex + 2][0] = (this.m_dGradientProfileArray[iPointIndex + 1][0] + this.m_dGradientProfileArray[iPointIndex + 3][0]) / 2.0;
                    this.m_dGradientProfileArray[iPointIndex + 2][1] = this.m_InterpolatedIdealGradientProfile.getAt(this.m_dGradientProfileArray[iPointIndex + 2][0]);
                }
            }
            ++i6;
        }
        int iNumPoints = 1000;
        int i7 = 0;
        while (i7 < iNumPoints) {
            double dXPos = (double)i7 / (double)(iNumPoints - 1) * this.m_dPlotXMax2;
            this.contentPane2.m_GraphControlFlowRate.AddDataPoint(iIdealPlotIndexFlowRate, dXPos * 60.0, this.m_dFlowRate / 1000.0);
            ++i7;
        }
        i7 = 0;
        while (i7 < iNumFlowDataPoints) {
            this.m_dFlowRateArray[i7][0] = this.m_dPlotXMax2 * ((double)i7 / ((double)iNumFlowDataPoints - 1.0));
            this.m_dFlowRateArray[i7][1] = this.m_dFlowRate;
            ++i7;
        }
        this.m_InterpolatedGradientProfile = new InterpolationFunction(this.m_dGradientProfileArray);
        this.m_InterpolatedFlowRate = new InterpolationFunction(this.m_dFlowRateArray);
        this.jMainScrollPane.setViewportView(this.contentPane2);
        this.updateGraphs(false);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String strActionCommand = evt.getActionCommand();
        if (strActionCommand == "Help") {
            Globals.hbMainHelpBroker.setCurrentID("step-by-step");
            Globals.hbMainHelpBroker.setDisplayed(true);
        } else if (strActionCommand == "Next Step") {
            this.nextStepButtonPressed();
        } else if (strActionCommand == "Previous Step") {
            if (this.m_iStage == 2) {
                this.jMainScrollPane.setViewportView(this.contentPane);
                if (this.task != null) {
                    this.task.cancel(true);
                }
                this.m_iStage = 1;
            }
        } else if (strActionCommand == "Calculate") {
            this.beginBackCalculation(false);
        } else if (strActionCommand == "Copy to clipboard") {
            this.copyProfilesToClipboard();
        } else if (strActionCommand == "Stop Calculations") {
            this.task.cancel(true);
        } else if (strActionCommand == "Preloaded Values") {
            Frame[] frames = Frame.getFrames();
            PreloadedValuesDialog dlgPreloadedValues = new PreloadedValuesDialog(frames[0]);
            dlgPreloadedValues.setVisible(true);
            if (!dlgPreloadedValues.m_bOk) {
                return;
            }
            this.contentPane.jtxtInnerDiameter.setText(Double.valueOf(Globals.dGradientPrograms[dlgPreloadedValues.m_iCondition][0][0]).toString());
            this.contentPane.jtxtColumnLength.setText(Double.valueOf(Globals.dGradientPrograms[dlgPreloadedValues.m_iCondition][0][1]).toString());
            this.contentPane.jtxtFlowRate.setText(Double.valueOf(Globals.dGradientPrograms[dlgPreloadedValues.m_iCondition][0][2]).toString());
            this.m_bDoNotChangeTable = true;
            this.contentPane.tmGradientProgram.setRowCount(0);
            int i = 1;
            while (i < Globals.dGradientPrograms[dlgPreloadedValues.m_iCondition].length) {
                Object[] rowData = new Object[]{Globals.dGradientPrograms[dlgPreloadedValues.m_iCondition][i][0], Globals.dGradientPrograms[dlgPreloadedValues.m_iCondition][i][1]};
                this.contentPane.tmGradientProgram.addRow(rowData);
                ++i;
            }
            i = 0;
            while (i < Globals.dPredefinedValues[dlgPreloadedValues.m_iCondition].length) {
                this.contentPane.tmMeasuredRetentionTimes.setValueAt(Globals.dPredefinedValues[dlgPreloadedValues.m_iCondition][i], i, 3);
                if (Globals.dPredefinedValues[dlgPreloadedValues.m_iCondition][i] > 0.0) {
                    this.contentPane.tmMeasuredRetentionTimes.setValueAt(true, i, 0);
                } else {
                    this.contentPane.tmMeasuredRetentionTimes.setValueAt(false, i, 0);
                }
                ++i;
            }
            this.performValidations();
        } else if (strActionCommand == "Insert Row") {
            int iSelectedRow = this.contentPane.jtableGradientProgram.getSelectedRow();
            if (iSelectedRow == -1) {
                iSelectedRow = this.contentPane.tmGradientProgram.getRowCount() - 1;
            }
            Double dRowValue1 = (Double)this.contentPane.tmGradientProgram.getValueAt(iSelectedRow, 0);
            Double dRowValue2 = (Double)this.contentPane.tmGradientProgram.getValueAt(iSelectedRow, 1);
            Object[] dRowData = new Double[]{dRowValue1, dRowValue2};
            this.contentPane.tmGradientProgram.insertRow(iSelectedRow + 1, dRowData);
        } else if (strActionCommand == "Remove Row") {
            int iSelectedRow = this.contentPane.jtableGradientProgram.getSelectedRow();
            if (iSelectedRow == -1) {
                iSelectedRow = this.contentPane.tmGradientProgram.getRowCount() - 1;
            }
            if (this.contentPane.tmGradientProgram.getRowCount() >= 3) {
                this.contentPane.tmGradientProgram.removeRow(iSelectedRow);
            }
        }
    }

    public void copyProfilesToClipboard() {
        String outString = "";
        String eol = System.getProperty("line.separator");
        outString = String.valueOf(outString) + "Programmed (initial) experimental conditions" + eol;
        outString = String.valueOf(outString) + "Stationary phase:\t" + Globals.StationaryPhaseArray[this.contentPane.jcboStationaryPhase.getSelectedIndex()] + eol;
        outString = String.valueOf(outString) + "Column inner diameter:\t" + this.contentPane.jtxtInnerDiameter.getText() + " mm" + eol;
        outString = String.valueOf(outString) + "Column length:\t" + this.contentPane.jtxtColumnLength.getText() + " mm" + eol;
        outString = String.valueOf(outString) + "Flow rate:\t" + this.contentPane.jtxtFlowRate.getText() + " mL/min" + eol;
        outString = String.valueOf(outString) + "Gradient program:" + eol;
        outString = String.valueOf(outString) + "Time (min)\tEluent composition (%B)" + eol;
        int i = 0;
        while (i < this.contentPane.tmGradientProgram.getRowCount()) {
            outString = String.valueOf(outString) + this.contentPane.tmGradientProgram.getValueAt(i, 0) + "\t" + this.contentPane.tmGradientProgram.getValueAt(i, 1) + eol;
            ++i;
        }
        outString = String.valueOf(outString) + eol;
        outString = String.valueOf(outString) + "Retention times of standards" + eol;
        outString = String.valueOf(outString) + "Standard\tExperimental retention time (min)\tCalculated retention time (min)\tDifference (min)" + eol;
        i = 0;
        while (i < this.contentPane2.tmOutputModel.getRowCount()) {
            outString = String.valueOf(outString) + this.contentPane2.tmOutputModel.getValueAt(i, 0) + "\t" + this.contentPane2.tmOutputModel.getValueAt(i, 1) + "\t" + this.contentPane2.tmOutputModel.getValueAt(i, 2) + "\t" + this.contentPane2.tmOutputModel.getValueAt(i, 3) + eol;
            ++i;
        }
        outString = String.valueOf(outString) + eol;
        outString = String.valueOf(outString) + "Back-calculated gradient profile\t\t\tBack-calculated flow rate profile" + eol;
        outString = String.valueOf(outString) + "Time (min)\tEluent composition (%B)\t\tTime(min)\tFlow rate (mL/min)" + eol;
        int iNumPoints = 1000;
        int i2 = 0;
        while (i2 < iNumPoints) {
            double dCurrentTime = this.m_dPlotXMax2 * ((double)i2 / ((double)iNumPoints - 1.0));
            double dCurrentSolventComposition = this.m_InterpolatedGradientProfile.getAt(dCurrentTime);
            double dCurrentFlowRate = this.m_InterpolatedFlowRate.getAt(dCurrentTime);
            outString = String.valueOf(outString) + Float.toString((float)dCurrentTime) + "\t" + Float.toString((float)dCurrentSolventComposition) + "\t\t" + Float.toString((float)dCurrentTime) + "\t" + Float.toString((float)dCurrentFlowRate) + eol;
            ++i2;
        }
        StringSelection stringSelection = new StringSelection(outString);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
        JOptionPane.showMessageDialog(null, "A report has been copied to the clipboard. You may now paste it into a spreadsheet.", "Measure Your Gradient", 1);
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (!Character.isDigit(e.getKeyChar()) && e.getKeyChar() != '\b' && e.getKeyChar() != '\u007f' && e.getKeyChar() != '.') {
            e.consume();
        }
        if (e.getKeyChar() == '\n') {
            this.performValidations();
        }
    }

    public void performValidations() {
        this.validateColumnLength();
        this.validateColumnInnerDiameter();
        this.validateFlowRate();
        this.m_V0 = Math.PI * Math.pow(this.m_dColumnInnerDiameter / 10.0 / 2.0, 2.0) * (this.m_dColumnLength / 10.0) / 1000.0;
        double dLongestRetentionTime = 0.0;
        int i = 0;
        while (i < this.contentPane.tmMeasuredRetentionTimes.getRowCount()) {
            double dValue = (Double)this.contentPane.tmMeasuredRetentionTimes.getValueAt(i, 3);
            if (dValue > dLongestRetentionTime) {
                dLongestRetentionTime = dValue;
            }
            ++i;
        }
        double dLastProgramTime = (Double)this.contentPane.tmGradientProgram.getValueAt(this.contentPane.tmGradientProgram.getRowCount() - 1, 0);
        this.m_dPlotXMax = Math.max(dLongestRetentionTime * 1.1, dLastProgramTime * 1.1);
        this.contentPane.m_GraphControlGradient.RemoveAllSeries();
        this.contentPane.m_GraphControlFlowRate.RemoveAllSeries();
        int iIdealPlotIndex = this.contentPane.m_GraphControlGradient.AddSeries("Ideal Gradient", new Color(0, 0, 0), 1, false, false);
        int iIdealPlotIndexHoldUp = this.contentPane.m_GraphControlFlowRate.AddSeries("Ideal Hold Up", new Color(0, 0, 0), 1, false, false);
        this.contentPane.m_GraphControlFlowRate.AddDataPoint(iIdealPlotIndexHoldUp, 0.0, this.m_dFlowRate / 1000.0);
        this.contentPane.m_GraphControlFlowRate.AddDataPoint(iIdealPlotIndexHoldUp, this.m_dPlotXMax * 60.0, this.m_dFlowRate / 1000.0);
        this.contentPane.m_GraphControlGradient.AddDataPoint(iIdealPlotIndex, 0.0, (Double)this.contentPane.tmGradientProgram.getValueAt(0, 1));
        double dLastTime = 0.0;
        int i2 = 0;
        while (i2 < this.contentPane.tmGradientProgram.getRowCount()) {
            if ((Double)this.contentPane.tmGradientProgram.getValueAt(i2, 0) > dLastTime) {
                double dTime = (Double)this.contentPane.tmGradientProgram.getValueAt(i2, 0);
                double dFractionB = (Double)this.contentPane.tmGradientProgram.getValueAt(i2, 1);
                this.contentPane.m_GraphControlGradient.AddDataPoint(iIdealPlotIndex, dTime * 60.0, dFractionB);
                dLastTime = dTime;
            }
            ++i2;
        }
        this.contentPane.m_GraphControlGradient.AddDataPoint(iIdealPlotIndex, this.m_dPlotXMax * 60.0, (Double)this.contentPane.tmGradientProgram.getValueAt(this.contentPane.tmGradientProgram.getRowCount() - 1, 1));
        this.contentPane.m_GraphControlGradient.AutoScaleX();
        this.contentPane.m_GraphControlGradient.AutoScaleY();
        this.contentPane.m_GraphControlGradient.repaint();
        this.contentPane.m_GraphControlFlowRate.AutoScaleX();
        this.contentPane.m_GraphControlFlowRate.AutoScaleY();
        this.contentPane.m_GraphControlFlowRate.repaint();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.performValidations();
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        this.performValidations();
    }

    @Override
    public void autoScaleChanged(AutoScaleEvent event) {
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int iChangedColumn;
        int iChangedRow;
        if (this.m_bDoNotChangeTable) {
            this.m_bDoNotChangeTable = false;
            return;
        }
        if (e.getSource() == this.contentPane.tmGradientProgram) {
            if (this.m_bDoNotChangeTable) {
                this.m_bDoNotChangeTable = false;
                return;
            }
            iChangedRow = e.getFirstRow();
            iChangedColumn = e.getColumn();
            Double dRowValue1 = 0.0;
            Double dRowValue2 = 0.0;
            if (iChangedRow < this.contentPane.tmGradientProgram.getRowCount()) {
                dRowValue1 = (Double)this.contentPane.tmGradientProgram.getValueAt(iChangedRow, 0);
                dRowValue2 = (Double)this.contentPane.tmGradientProgram.getValueAt(iChangedRow, 1);
            }
            if (iChangedColumn == 0) {
                Double dPreviousTime;
                if (iChangedRow == 0) {
                    dRowValue1 = 0.0;
                } else if (iChangedRow == this.contentPane.tmGradientProgram.getRowCount() - 1) {
                    dPreviousTime = (Double)this.contentPane.tmGradientProgram.getValueAt(this.contentPane.tmGradientProgram.getRowCount() - 2, 0);
                    if (dRowValue1 < dPreviousTime) {
                        dRowValue1 = dPreviousTime;
                    }
                } else {
                    dPreviousTime = (Double)this.contentPane.tmGradientProgram.getValueAt(iChangedRow - 1, 0);
                    Double dNextTime = (Double)this.contentPane.tmGradientProgram.getValueAt(iChangedRow + 1, 0);
                    if (dRowValue1 < dPreviousTime) {
                        dRowValue1 = dPreviousTime;
                    }
                    if (dRowValue1 > dNextTime) {
                        dRowValue1 = dNextTime;
                    }
                }
                this.m_bDoNotChangeTable = true;
                this.contentPane.tmGradientProgram.setValueAt(dRowValue1, iChangedRow, iChangedColumn);
            } else if (iChangedColumn == 1) {
                if (dRowValue2 > 100.0) {
                    dRowValue2 = 100.0;
                }
                if (dRowValue2 < 0.0) {
                    dRowValue2 = 0.0;
                }
                this.m_bDoNotChangeTable = true;
                this.contentPane.tmGradientProgram.setValueAt(dRowValue2, iChangedRow, iChangedColumn);
            }
        } else if (e.getSource() == this.contentPane.tmMeasuredRetentionTimes) {
            iChangedRow = e.getFirstRow();
            iChangedColumn = e.getColumn();
            if (iChangedColumn == 3) {
                double dNewValue;
                if (this.contentPane.tmMeasuredRetentionTimes.getValueAt(iChangedRow, 3) == null) {
                    this.m_bDoNotChangeTable = true;
                    this.contentPane.tmMeasuredRetentionTimes.setValueAt(0.0, iChangedRow, 3);
                }
                if ((dNewValue = ((Double)this.contentPane.tmMeasuredRetentionTimes.getValueAt(iChangedRow, 3)).doubleValue()) < 0.0) {
                    dNewValue = 0.0;
                }
                if (dNewValue > 9999999.0) {
                    dNewValue = 9999999.0;
                }
                this.m_bDoNotChangeTable = true;
                this.contentPane.tmMeasuredRetentionTimes.setValueAt(dNewValue, iChangedRow, 3);
                this.m_bDoNotChangeTable = true;
                if (dNewValue <= 0.0) {
                    this.contentPane.tmMeasuredRetentionTimes.setValueAt(false, iChangedRow, 0);
                } else {
                    this.contentPane.tmMeasuredRetentionTimes.setValueAt(true, iChangedRow, 0);
                }
            }
        }
        this.performValidations();
        this.contentPane.m_GraphControlGradient.removeAllLineMarkers();
        this.contentPane.m_GraphControlFlowRate.removeAllLineMarkers();
        int i = 0;
        while (i < this.contentPane.tmMeasuredRetentionTimes.getRowCount()) {
            if (((Boolean)this.contentPane.tmMeasuredRetentionTimes.getValueAt(i, 0)).booleanValue()) {
                this.contentPane.m_GraphControlGradient.addLineMarker((Double)this.contentPane.tmMeasuredRetentionTimes.getValueAt(i, 3), (String)this.contentPane.tmMeasuredRetentionTimes.getValueAt(i, 1));
                this.contentPane.m_GraphControlFlowRate.addLineMarker((Double)this.contentPane.tmMeasuredRetentionTimes.getValueAt(i, 3), (String)this.contentPane.tmMeasuredRetentionTimes.getValueAt(i, 1));
            }
            ++i;
        }
        this.contentPane.m_GraphControlGradient.repaint();
        this.contentPane.m_GraphControlFlowRate.repaint();
        int iNumUsed = 0;
        int i2 = 0;
        while (i2 < this.contentPane.tmMeasuredRetentionTimes.getRowCount()) {
            if (((Boolean)this.contentPane.tmMeasuredRetentionTimes.getValueAt(i2, 0)).booleanValue()) {
                ++iNumUsed;
            }
            ++i2;
        }
        if (iNumUsed >= 6) {
            this.contentPane.jbtnNextStep.setEnabled(true);
        } else {
            this.contentPane.jbtnNextStep.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGraphs(boolean bAlsoUpdateTable) {
        Object object = this.contentPane2.m_GraphControlGradient.lockObject;
        synchronized (object) {
            Object object2 = this.contentPane2.m_GraphControlFlowRate.lockObject;
            synchronized (object2) {
                this.contentPane2.m_GraphControlGradient.RemoveSeries(this.m_iInterpolatedGradientProgramSeries);
                this.contentPane2.m_GraphControlGradient.RemoveSeries(this.m_iGradientProgramMarkerSeries);
                this.contentPane2.m_GraphControlFlowRate.RemoveSeries(this.m_iInterpolatedFlowRateSeries);
                this.contentPane2.m_GraphControlFlowRate.RemoveSeries(this.m_iFlowRateMarkerSeries);
                this.m_iInterpolatedGradientProgramSeries = this.contentPane2.m_GraphControlGradient.AddSeries("Interpolated Gradient", new Color(255, 0, 0), 1, false, false);
                this.m_iGradientProgramMarkerSeries = this.contentPane2.m_GraphControlGradient.AddSeries("Gradient Markers", new Color(255, 0, 0), 1, true, false);
                this.m_iInterpolatedFlowRateSeries = this.contentPane2.m_GraphControlFlowRate.AddSeries("Interpolated Flow", new Color(255, 0, 0), 1, false, false);
                this.m_iFlowRateMarkerSeries = this.contentPane2.m_GraphControlFlowRate.AddSeries("Flow Rate Markers", new Color(255, 0, 0), 1, true, false);
                int iNumPoints = 1000;
                int i = 0;
                while (i < iNumPoints) {
                    double dXPos = (double)i / (double)(iNumPoints - 1) * (this.m_dPlotXMax2 * 60.0);
                    this.contentPane2.m_GraphControlGradient.AddDataPoint(this.m_iInterpolatedGradientProgramSeries, dXPos, this.m_InterpolatedGradientProfile.getAt(dXPos / 60.0));
                    this.contentPane2.m_GraphControlFlowRate.AddDataPoint(this.m_iInterpolatedFlowRateSeries, dXPos, this.m_InterpolatedFlowRate.getAt(dXPos / 60.0) / 1000.0);
                    ++i;
                }
                i = 0;
                while (i < this.m_dGradientProfileArray.length) {
                    this.contentPane2.m_GraphControlGradient.AddDataPoint(this.m_iGradientProgramMarkerSeries, this.m_dGradientProfileArray[i][0] * 60.0, this.m_dGradientProfileArray[i][1]);
                    ++i;
                }
                i = 0;
                while (i < this.m_dFlowRateArray.length) {
                    this.contentPane2.m_GraphControlFlowRate.AddDataPoint(this.m_iFlowRateMarkerSeries, this.m_dFlowRateArray[i][0] * 60.0, this.m_dFlowRateArray[i][1] / 1000.0);
                    ++i;
                }
                this.contentPane2.m_GraphControlGradient.AutoScaleToSeries(this.m_iInterpolatedGradientProgramSeries);
                this.contentPane2.m_GraphControlGradient.AutoScaleY();
                this.contentPane2.m_GraphControlFlowRate.AutoScaleX();
                this.contentPane2.m_GraphControlFlowRate.AutoScaleY();
                this.contentPane2.m_GraphControlGradient.repaint();
                this.contentPane2.m_GraphControlFlowRate.repaint();
                if (bAlsoUpdateTable) {
                    DecimalFormat formatter = new DecimalFormat("#0.0000");
                    int i2 = 0;
                    while (i2 < this.m_vectCalCompounds.size()) {
                        double dMeasuredTime = (Double)this.m_vectCalCompounds.get(i2)[1];
                        double dPredictedTime = (Double)this.m_vectCalCompounds.get(i2)[2];
                        if (dPredictedTime >= 0.0) {
                            this.contentPane2.tmOutputModel.setValueAt(formatter.format(dPredictedTime), i2, 2);
                            this.contentPane2.tmOutputModel.setValueAt(formatter.format(dPredictedTime - dMeasuredTime), i2, 3);
                        } else {
                            this.contentPane2.tmOutputModel.setValueAt("Did not elute", i2, 2);
                            this.contentPane2.tmOutputModel.setValueAt("-", i2, 3);
                        }
                        ++i2;
                    }
                }
            }
        }
    }

    public void beginBackCalculation(boolean bFlowRateProfileBackCalculationFirst) {
        this.contentPane2.jbtnCalculate.setEnabled(false);
        this.contentPane2.jProgressBar.setIndeterminate(true);
        this.contentPane2.jProgressBar.setStringPainted(true);
        this.contentPane2.jProgressBar.setString("Please wait, optimization in progress...");
        this.task = new Task();
        this.task.setOptimizationOrder(bFlowRateProfileBackCalculationFirst);
        this.task.execute();
    }

    public double calcRetentionError(double dtstep, int iNumCompoundsToInclude) {
        double dRetentionError = 0.0;
        int iCompound = 0;
        while (iCompound < iNumCompoundsToInclude) {
            double dIntegral = 0.0;
            double dtRFinal = 0.0;
            double dD = 0.0;
            double dTotalTime = 0.0;
            double dTotalDeadTime = 0.0;
            double dXPosition = 0.0;
            double[] dLastXPosition = new double[]{0.0, 0.0};
            double[] dLastko = new double[]{0.0, 0.0};
            double dXMovement = 0.0;
            Boolean bIsEluted = false;
            double dPhiC = 0.0;
            double dCurVal = 0.0;
            double t = 0.0;
            while (t <= (Double)this.m_vectCalCompounds.get(this.m_vectCalCompounds.size() - 1)[1] * 1.5) {
                dPhiC = this.m_InterpolatedGradientProfile.getAt(dTotalTime - dIntegral) / 100.0;
                dCurVal = dtstep / Math.pow(10.0, this.m_StandardIsocraticDataInterpolated[iCompound].getAt(dPhiC));
                double dt0 = this.m_Vm.getAt(dPhiC) / this.m_InterpolatedFlowRate.getAt(dTotalTime - dIntegral);
                dXMovement = dCurVal / dt0;
                if (dXPosition >= 1.0) {
                    dD = (1.0 - dLastXPosition[0]) / (dXPosition - dLastXPosition[0]) * (dTotalDeadTime - dLastXPosition[1]) + dLastXPosition[1];
                } else {
                    dLastXPosition[0] = dXPosition;
                    dLastXPosition[1] = dTotalDeadTime;
                }
                dTotalDeadTime += dXMovement * dt0;
                if (dXPosition >= 1.0) {
                    dtRFinal = (dD - dLastko[0]) / (dIntegral - dLastko[0]) * (dTotalTime - dLastko[1]) + dLastko[1];
                } else {
                    dLastko[0] = dIntegral;
                    dLastko[1] = dTotalTime;
                }
                dTotalTime += dtstep + dCurVal;
                dIntegral += dCurVal;
                if (dXPosition > 1.0 && !bIsEluted.booleanValue()) {
                    bIsEluted = true;
                    break;
                }
                dXPosition += dXMovement;
                t += dtstep;
            }
            if (bIsEluted.booleanValue()) {
                dRetentionError += Math.pow(dtRFinal - (Double)this.m_vectCalCompounds.get(iCompound)[1], 2.0);
                this.m_vectCalCompounds.get((int)iCompound)[2] = dtRFinal;
            } else {
                dRetentionError += Math.pow((Double)this.m_vectCalCompounds.get(iCompound)[1], 2.0);
                this.m_vectCalCompounds.get((int)iCompound)[2] = -1.0;
            }
            ++iCompound;
        }
        return dRetentionError;
    }

    public void updateTime(long starttime) {
        DecimalFormat timeformatter = new DecimalFormat("00");
        long currentTime = System.currentTimeMillis();
        long lNumSecondsPassed = (currentTime - starttime) / 1000L;
        long lNumDaysPassed = lNumSecondsPassed / 86400L;
        long lNumHoursPassed = (lNumSecondsPassed -= lNumDaysPassed * 86400L) / 3600L;
        long lNumMinutesPassed = (lNumSecondsPassed -= lNumHoursPassed * 3600L) / 60L;
        String strProgress2 = "";
        strProgress2 = String.valueOf(strProgress2) + timeformatter.format(lNumHoursPassed) + ":" + timeformatter.format(lNumMinutesPassed) + ":" + timeformatter.format(lNumSecondsPassed -= lNumMinutesPassed * 60L);
        this.contentPane2.jlblTimeElapsed.setText(strProgress2);
    }

    public double calcAngleDifferenceFlowRate(int iIndex) {
        double dTotalAngleError = 0.0;
        double dHoldUpRange = 20.0;
        int i = 0;
        while (i < this.m_dFlowRateArray.length) {
            if (i >= 2) {
                double dTime2 = this.m_dFlowRateArray[i][0];
                double dHoldUp2 = this.m_dFlowRateArray[i][1];
                double dTime1 = this.m_dFlowRateArray[i - 1][0];
                double dHoldUp1 = this.m_dFlowRateArray[i - 1][1];
                double dTime0 = this.m_dFlowRateArray[i - 2][0];
                double dHoldUp0 = this.m_dFlowRateArray[i - 2][1];
                double dPreviousAdjacent = (dHoldUp1 - dHoldUp0) / dHoldUpRange;
                double dPreviousOpposite = dTime1 - dTime0;
                double dPreviousAngle = dPreviousAdjacent == 0.0 ? 1.5707963267948966 : Math.atan(dPreviousOpposite / dPreviousAdjacent);
                if (dPreviousAngle < 0.0) {
                    dPreviousAngle += Math.PI;
                }
                double dAdjacent = (dHoldUp2 - dHoldUp1) / dHoldUpRange;
                double dOpposite = dTime2 - dTime1;
                double dNewAngle = dAdjacent == 0.0 ? 1.5707963267948966 : Math.atan(dOpposite / dAdjacent);
                if (dNewAngle < 0.0) {
                    dNewAngle += Math.PI;
                }
                double dFactor1 = 300.0;
                double dAngleError = Math.pow(Math.abs(dNewAngle - dPreviousAngle) / Math.PI * dFactor1, 2.0) + 1.0;
                dTotalAngleError += dAngleError;
            }
            ++i;
        }
        return dTotalAngleError;
    }

    public double calcAngleDifferenceGradient(int iIndex) {
        double dTotalAngleError = 0.0;
        double dMaxRampRate = 50.0;
        int i = 0;
        while (i < this.m_dGradientProfileArray.length) {
            if (i >= 2) {
                double dTime2 = this.m_dGradientProfileArray[i][0];
                double dTemp2 = this.m_dGradientProfileArray[i][1];
                double dTime1 = this.m_dGradientProfileArray[i - 1][0];
                double dTemp1 = this.m_dGradientProfileArray[i - 1][1];
                double dTime0 = this.m_dGradientProfileArray[i - 2][0];
                double dTemp0 = this.m_dGradientProfileArray[i - 2][1];
                boolean bIsCorner = false;
                int j = 0;
                while (j < this.m_dIdealGradientProfileArray.length - 1) {
                    if (this.m_dIdealGradientProfileArray[j][0] == dTime1) {
                        bIsCorner = true;
                        break;
                    }
                    ++j;
                }
                if (!bIsCorner) {
                    double dPreviousAdjacent = (dTemp1 - dTemp0) / dMaxRampRate;
                    double dPreviousOpposite = dTime1 - dTime0;
                    double dPreviousAngle = dPreviousAdjacent == 0.0 ? 1.5707963267948966 : Math.atan(dPreviousOpposite / dPreviousAdjacent);
                    if (dPreviousAngle < 0.0) {
                        dPreviousAngle += Math.PI;
                    }
                    double dAdjacent = (dTemp2 - dTemp1) / dMaxRampRate;
                    double dOpposite = dTime2 - dTime1;
                    double dNewAngle = dAdjacent == 0.0 ? 1.5707963267948966 : Math.atan(dOpposite / dAdjacent);
                    if (dNewAngle < 0.0) {
                        dNewAngle += Math.PI;
                    }
                    double dFactor1 = 10.0;
                    double dAngleError = Math.pow(Math.abs(dNewAngle - dPreviousAngle) / Math.PI * dFactor1, 2.0) + 1.0;
                    dTotalAngleError += dAngleError;
                }
            }
            ++i;
        }
        return dTotalAngleError;
    }

    /*
     * Unable to fully structure code
     */
    public double goldenSectioningSearchGradientProfile(int iIndex, double dStep, double dPrecision, double dMaxChangeAtOnce, boolean bMinimizeAngles) {
        dRetentionError = 1.0;
        dLastTempGuess = this.m_dGradientProfileArray[iIndex][1];
        x1 = this.m_dGradientProfileArray[iIndex][1];
        dRetentionErrorX1 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
        dAngleErrorX1 = bMinimizeAngles != false ? this.calcAngleDifferenceGradient(iIndex) : 1.0;
        this.m_dGradientProfileArray[iIndex][1] = x2 = x1 + dStep;
        this.m_InterpolatedGradientProfile = new InterpolationFunction(this.m_dGradientProfileArray);
        dRetentionErrorX2 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
        if (dRetentionErrorX2 * (dAngleErrorX2 = bMinimizeAngles != false ? this.calcAngleDifferenceGradient(iIndex) : 1.0) < dRetentionErrorX1 * dAngleErrorX1) {
            x3 = x2;
            dRetentionErrorX3 = dRetentionErrorX2;
            dAngleErrorX3 = dAngleErrorX2;
            this.m_dGradientProfileArray[iIndex][1] = x2 = (x3 - x1) * this.m_dGoldenRatio + x3;
            this.m_InterpolatedGradientProfile = new InterpolationFunction(this.m_dGradientProfileArray);
            dRetentionErrorX2 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
            dAngleErrorX2 = bMinimizeAngles ? this.calcAngleDifferenceGradient(iIndex) : 1.0;
            while (dRetentionErrorX2 * dAngleErrorX2 < dRetentionErrorX3 * dAngleErrorX3 && x2 < dLastTempGuess + dMaxChangeAtOnce) {
                x1 = x3;
                dRetentionErrorX1 = dRetentionErrorX3;
                dAngleErrorX1 = dAngleErrorX3;
                x3 = x2;
                dRetentionErrorX3 = dRetentionErrorX2;
                dAngleErrorX3 = dAngleErrorX2;
                this.m_dGradientProfileArray[iIndex][1] = x2 = (x3 - x1) * this.m_dGoldenRatio + x3;
                this.m_InterpolatedGradientProfile = new InterpolationFunction(this.m_dGradientProfileArray);
                dRetentionErrorX2 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
                dAngleErrorX2 = bMinimizeAngles != false ? this.calcAngleDifferenceGradient(iIndex) : 1.0;
            }
        } else {
            x3 = x1;
            dRetentionErrorX3 = dRetentionErrorX1;
            dAngleErrorX3 = dAngleErrorX1;
            this.m_dGradientProfileArray[iIndex][1] = x1 = x3 - (x2 - x3) * this.m_dGoldenRatio;
            this.m_InterpolatedGradientProfile = new InterpolationFunction(this.m_dGradientProfileArray);
            dRetentionErrorX1 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
            dAngleErrorX1 = bMinimizeAngles ? this.calcAngleDifferenceGradient(iIndex) : 1.0;
            while (dRetentionErrorX1 * dAngleErrorX1 < dRetentionErrorX3 * dAngleErrorX3 && x1 > dLastTempGuess - dMaxChangeAtOnce) {
                x2 = x3;
                dRetentionErrorX2 = dRetentionErrorX3;
                dAngleErrorX2 = dAngleErrorX3;
                x3 = x1;
                dRetentionErrorX3 = dRetentionErrorX1;
                dAngleErrorX3 = dAngleErrorX1;
                this.m_dGradientProfileArray[iIndex][1] = x1 = x3 - (x2 - x3) * this.m_dGoldenRatio;
                this.m_InterpolatedGradientProfile = new InterpolationFunction(this.m_dGradientProfileArray);
                dRetentionErrorX1 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
                dAngleErrorX1 = bMinimizeAngles != false ? this.calcAngleDifferenceGradient(iIndex) : 1.0;
            }
        }
        if (x2 > dLastTempGuess + dMaxChangeAtOnce) {
            this.m_dGradientProfileArray[iIndex][1] = dLastTempGuess + dMaxChangeAtOnce > 100.0 ? 100.0 : dLastTempGuess + dMaxChangeAtOnce;
            this.m_InterpolatedGradientProfile = new InterpolationFunction(this.m_dGradientProfileArray);
            dRetentionError = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
            return dRetentionError;
        }
        if (!(x1 < dLastTempGuess - dMaxChangeAtOnce)) ** GOTO lbl87
        this.m_dGradientProfileArray[iIndex][1] = dLastTempGuess - dMaxChangeAtOnce < 0.0 ? 0.0 : dLastTempGuess - dMaxChangeAtOnce;
        this.m_InterpolatedGradientProfile = new InterpolationFunction(this.m_dGradientProfileArray);
        dRetentionError = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
        return dRetentionError;
lbl-1000:
        // 1 sources

        {
            x4 = x2 - x3 > x3 - x1 ? x3 + (2.0 - this.m_dGoldenRatio) * (x2 - x3) : x3 - (2.0 - this.m_dGoldenRatio) * (x3 - x1);
            this.m_dGradientProfileArray[iIndex][1] = x4;
            this.m_InterpolatedGradientProfile = new InterpolationFunction(this.m_dGradientProfileArray);
            dRetentionErrorX4 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
            if (dRetentionErrorX4 * (dAngleErrorX4 = bMinimizeAngles != false ? this.calcAngleDifferenceGradient(iIndex) : 1.0) < dRetentionErrorX3 * dAngleErrorX3) {
                if (x2 - x3 > x3 - x1) {
                    x1 = x3;
                    dRetentionErrorX1 = dRetentionErrorX3;
                    dAngleErrorX1 = dAngleErrorX3;
                    x3 = x4;
                    dRetentionErrorX3 = dRetentionErrorX4;
                    dAngleErrorX3 = dAngleErrorX4;
                    continue;
                }
                x2 = x3;
                dRetentionErrorX2 = dRetentionErrorX3;
                dAngleErrorX2 = dAngleErrorX3;
                x3 = x4;
                dRetentionErrorX3 = dRetentionErrorX4;
                dAngleErrorX3 = dAngleErrorX4;
                continue;
            }
            if (x2 - x3 > x3 - x1) {
                x2 = x4;
                dRetentionErrorX2 = dRetentionErrorX4;
                dAngleErrorX2 = dAngleErrorX4;
                continue;
            }
            x1 = x4;
            dRetentionErrorX1 = dRetentionErrorX4;
            dAngleErrorX1 = dAngleErrorX4;
lbl87:
            // 5 sources

            ** while (x2 - x1 > dPrecision)
        }
lbl88:
        // 1 sources

        if (x3 > 100.0) {
            this.m_dGradientProfileArray[iIndex][1] = 100.0;
            this.m_InterpolatedGradientProfile = new InterpolationFunction(this.m_dGradientProfileArray);
            dRetentionError = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
        } else if (x3 < 0.0) {
            this.m_dGradientProfileArray[iIndex][1] = 0.0;
            this.m_InterpolatedGradientProfile = new InterpolationFunction(this.m_dGradientProfileArray);
            dRetentionError = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
        } else {
            this.m_dGradientProfileArray[iIndex][1] = x3;
            this.m_InterpolatedGradientProfile = new InterpolationFunction(this.m_dGradientProfileArray);
            dRetentionError = dRetentionErrorX3;
        }
        return dRetentionError;
    }

    /*
     * Unable to fully structure code
     */
    public double goldenSectioningSearchHoldUp(int iIndex, double dStep, double dPrecision, double dMaxChangeAtOnce, boolean bMinimizeAngles) {
        dRetentionError = 1.0;
        dLastFGuess = this.m_dFlowRateArray[iIndex][1];
        x1 = this.m_dFlowRateArray[iIndex][1];
        dRetentionErrorX1 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
        dAngleErrorX1 = bMinimizeAngles != false ? this.calcAngleDifferenceFlowRate(iIndex) : 1.0;
        this.m_dFlowRateArray[iIndex][1] = x2 = x1 + dStep;
        this.m_InterpolatedFlowRate = new InterpolationFunction(this.m_dFlowRateArray);
        dRetentionErrorX2 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
        if (dRetentionErrorX2 * (dAngleErrorX2 = bMinimizeAngles != false ? this.calcAngleDifferenceFlowRate(iIndex) : 1.0) < dRetentionErrorX1 * dAngleErrorX1) {
            x3 = x2;
            dRetentionErrorX3 = dRetentionErrorX2;
            dAngleErrorX3 = dAngleErrorX2;
            this.m_dFlowRateArray[iIndex][1] = x2 = (x3 - x1) * this.m_dGoldenRatio + x3;
            this.m_InterpolatedFlowRate = new InterpolationFunction(this.m_dFlowRateArray);
            dRetentionErrorX2 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
            dAngleErrorX2 = bMinimizeAngles ? this.calcAngleDifferenceFlowRate(iIndex) : 1.0;
            while (dRetentionErrorX2 * dAngleErrorX2 < dRetentionErrorX3 * dAngleErrorX3 && x2 < dLastFGuess + dMaxChangeAtOnce) {
                x1 = x3;
                dRetentionErrorX1 = dRetentionErrorX3;
                dAngleErrorX1 = dAngleErrorX3;
                x3 = x2;
                dRetentionErrorX3 = dRetentionErrorX2;
                dAngleErrorX3 = dAngleErrorX2;
                this.m_dFlowRateArray[iIndex][1] = x2 = (x3 - x1) * this.m_dGoldenRatio + x3;
                this.m_InterpolatedFlowRate = new InterpolationFunction(this.m_dFlowRateArray);
                dRetentionErrorX2 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
                dAngleErrorX2 = bMinimizeAngles != false ? this.calcAngleDifferenceFlowRate(iIndex) : 1.0;
            }
        } else {
            x3 = x1;
            dRetentionErrorX3 = dRetentionErrorX1;
            dAngleErrorX3 = dAngleErrorX1;
            this.m_dFlowRateArray[iIndex][1] = x1 = x3 - (x2 - x3) * this.m_dGoldenRatio;
            this.m_InterpolatedFlowRate = new InterpolationFunction(this.m_dFlowRateArray);
            dRetentionErrorX1 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
            dAngleErrorX1 = bMinimizeAngles ? this.calcAngleDifferenceFlowRate(iIndex) : 1.0;
            while (dRetentionErrorX1 * dAngleErrorX1 < dRetentionErrorX3 * dAngleErrorX3 && x1 > dLastFGuess - dMaxChangeAtOnce) {
                x2 = x3;
                dRetentionErrorX2 = dRetentionErrorX3;
                dAngleErrorX2 = dAngleErrorX3;
                x3 = x1;
                dRetentionErrorX3 = dRetentionErrorX1;
                dAngleErrorX3 = dAngleErrorX1;
                this.m_dFlowRateArray[iIndex][1] = x1 = x3 - (x2 - x3) * this.m_dGoldenRatio;
                this.m_InterpolatedFlowRate = new InterpolationFunction(this.m_dFlowRateArray);
                dRetentionErrorX1 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
                dAngleErrorX1 = bMinimizeAngles != false ? this.calcAngleDifferenceFlowRate(iIndex) : 1.0;
            }
        }
        if (x2 > dLastFGuess + dMaxChangeAtOnce) {
            this.m_dFlowRateArray[iIndex][1] = dLastFGuess + dMaxChangeAtOnce;
            this.m_InterpolatedFlowRate = new InterpolationFunction(this.m_dFlowRateArray);
            dRetentionError = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
            return dRetentionError;
        }
        if (!(x1 < dLastFGuess - dMaxChangeAtOnce)) ** GOTO lbl87
        this.m_dFlowRateArray[iIndex][1] = dLastFGuess - dMaxChangeAtOnce;
        this.m_InterpolatedFlowRate = new InterpolationFunction(this.m_dFlowRateArray);
        dRetentionError = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
        return dRetentionError;
lbl-1000:
        // 1 sources

        {
            x4 = x2 - x3 > x3 - x1 ? x3 + (2.0 - this.m_dGoldenRatio) * (x2 - x3) : x3 - (2.0 - this.m_dGoldenRatio) * (x3 - x1);
            this.m_dFlowRateArray[iIndex][1] = x4;
            this.m_InterpolatedFlowRate = new InterpolationFunction(this.m_dFlowRateArray);
            dRetentionErrorX4 = this.calcRetentionError(this.m_dtstep, this.m_vectCalCompounds.size());
            if (dRetentionErrorX4 * (dAngleErrorX4 = bMinimizeAngles != false ? this.calcAngleDifferenceFlowRate(iIndex) : 1.0) < dRetentionErrorX3 * dAngleErrorX3) {
                if (x2 - x3 > x3 - x1) {
                    x1 = x3;
                    dRetentionErrorX1 = dRetentionErrorX3;
                    dAngleErrorX1 = dAngleErrorX3;
                    x3 = x4;
                    dRetentionErrorX3 = dRetentionErrorX4;
                    dAngleErrorX3 = dAngleErrorX4;
                    continue;
                }
                x2 = x3;
                dRetentionErrorX2 = dRetentionErrorX3;
                dAngleErrorX2 = dAngleErrorX3;
                x3 = x4;
                dRetentionErrorX3 = dRetentionErrorX4;
                dAngleErrorX3 = dAngleErrorX4;
                continue;
            }
            if (x2 - x3 > x3 - x1) {
                x2 = x4;
                dRetentionErrorX2 = dRetentionErrorX4;
                dAngleErrorX2 = dAngleErrorX4;
                continue;
            }
            x1 = x4;
            dRetentionErrorX1 = dRetentionErrorX4;
            dAngleErrorX1 = dAngleErrorX4;
lbl87:
            // 5 sources

            ** while (x2 - x1 > dPrecision)
        }
lbl88:
        // 1 sources

        this.m_dFlowRateArray[iIndex][1] = x3;
        this.m_InterpolatedFlowRate = new InterpolationFunction(this.m_dFlowRateArray);
        dRetentionError = dRetentionErrorX3;
        return dRetentionError;
    }

    public double goldenSectioningSearchHoldUpOffset(double dStep, double dPrecision, int iNumCompoundsToUse) {
        double dRetentionErrorF3;
        double F3;
        double dRetentionError = 1.0;
        double F1 = this.m_dFlowRateArray[0][1];
        double dRetentionErrorF1 = this.calcRetentionError(this.m_dtstep, iNumCompoundsToUse);
        double F2 = F1 + dStep;
        double dDiff = F2 - this.m_dFlowRateArray[0][1];
        int i = 0;
        while (i < this.m_dFlowRateArray.length) {
            double[] dArray = this.m_dFlowRateArray[i];
            dArray[1] = dArray[1] + dDiff;
            ++i;
        }
        this.m_InterpolatedFlowRate = new InterpolationFunction(this.m_dFlowRateArray);
        double dRetentionErrorF2 = this.calcRetentionError(this.m_dtstep, iNumCompoundsToUse);
        if (dRetentionErrorF2 < dRetentionErrorF1) {
            F3 = F2;
            dRetentionErrorF3 = dRetentionErrorF2;
            F2 = (F3 - F1) * this.m_dGoldenRatio + F3;
            dDiff = F2 - this.m_dFlowRateArray[0][1];
            i = 0;
            while (i < this.m_dFlowRateArray.length) {
                double[] dArray = this.m_dFlowRateArray[i];
                dArray[1] = dArray[1] + dDiff;
                ++i;
            }
            this.m_InterpolatedFlowRate = new InterpolationFunction(this.m_dFlowRateArray);
            dRetentionErrorF2 = this.calcRetentionError(this.m_dtstep, iNumCompoundsToUse);
            while (dRetentionErrorF2 < dRetentionErrorF3) {
                F1 = F3;
                dRetentionErrorF1 = dRetentionErrorF3;
                F3 = F2;
                dRetentionErrorF3 = dRetentionErrorF2;
                F2 = (F3 - F1) * this.m_dGoldenRatio + F3;
                dDiff = F2 - this.m_dFlowRateArray[0][1];
                i = 0;
                while (i < this.m_dFlowRateArray.length) {
                    double[] dArray = this.m_dFlowRateArray[i];
                    dArray[1] = dArray[1] + dDiff;
                    ++i;
                }
                this.m_InterpolatedFlowRate = new InterpolationFunction(this.m_dFlowRateArray);
                dRetentionErrorF2 = this.calcRetentionError(this.m_dtstep, iNumCompoundsToUse);
            }
        } else {
            F3 = F1;
            dRetentionErrorF3 = dRetentionErrorF1;
            F1 = F3 - (F2 - F3) * this.m_dGoldenRatio;
            dDiff = F1 - this.m_dFlowRateArray[0][1];
            i = 0;
            while (i < this.m_dFlowRateArray.length) {
                double[] dArray = this.m_dFlowRateArray[i];
                dArray[1] = dArray[1] + dDiff;
                ++i;
            }
            this.m_InterpolatedFlowRate = new InterpolationFunction(this.m_dFlowRateArray);
            dRetentionErrorF1 = this.calcRetentionError(this.m_dtstep, iNumCompoundsToUse);
            while (dRetentionErrorF1 < dRetentionErrorF3) {
                F2 = F3;
                dRetentionErrorF2 = dRetentionErrorF3;
                F3 = F1;
                dRetentionErrorF3 = dRetentionErrorF1;
                F1 = F3 - (F2 - F3) * this.m_dGoldenRatio;
                dDiff = F1 - this.m_dFlowRateArray[0][1];
                i = 0;
                while (i < this.m_dFlowRateArray.length) {
                    double[] dArray = this.m_dFlowRateArray[i];
                    dArray[1] = dArray[1] + dDiff;
                    ++i;
                }
                this.m_InterpolatedFlowRate = new InterpolationFunction(this.m_dFlowRateArray);
                dRetentionErrorF1 = this.calcRetentionError(this.m_dtstep, iNumCompoundsToUse);
            }
        }
        while (F2 - F1 > dPrecision) {
            double F4 = F2 - F3 > F3 - F1 ? F3 + (2.0 - this.m_dGoldenRatio) * (F2 - F3) : F3 - (2.0 - this.m_dGoldenRatio) * (F3 - F1);
            dDiff = F4 - this.m_dFlowRateArray[0][1];
            int i2 = 0;
            while (i2 < this.m_dFlowRateArray.length) {
                double[] dArray = this.m_dFlowRateArray[i2];
                dArray[1] = dArray[1] + dDiff;
                ++i2;
            }
            this.m_InterpolatedFlowRate = new InterpolationFunction(this.m_dFlowRateArray);
            double dRetentionErrorF4 = this.calcRetentionError(this.m_dtstep, iNumCompoundsToUse);
            if (dRetentionErrorF4 < dRetentionErrorF3) {
                if (F2 - F3 > F3 - F1) {
                    F1 = F3;
                    dRetentionErrorF1 = dRetentionErrorF3;
                    F3 = F4;
                    dRetentionErrorF3 = dRetentionErrorF4;
                    continue;
                }
                F2 = F3;
                dRetentionErrorF2 = dRetentionErrorF3;
                F3 = F4;
                dRetentionErrorF3 = dRetentionErrorF4;
                continue;
            }
            if (F2 - F3 > F3 - F1) {
                F2 = F4;
                dRetentionErrorF2 = dRetentionErrorF4;
                continue;
            }
            F1 = F4;
            dRetentionErrorF1 = dRetentionErrorF4;
        }
        dRetentionError = dRetentionErrorF3;
        return dRetentionError;
    }

    public void backCalculate(Task task, boolean bHoldUpProfileFirst) {
        long starttime = System.currentTimeMillis();
        this.m_dGradientArrayStore = new double[300][this.m_dGradientProfileArray.length][2];
        this.m_dFlowRateArrayStore = new double[300][this.m_dFlowRateArray.length][2];
        this.m_dRetentionErrorStore = new double[300];
        boolean bBackCalculateGradientProfile = false;
        boolean bBackCalculateFlowRateProfile = false;
        boolean bMinimizeAnglesGradientProfile = true;
        boolean bMinimizeAnglesFlowRateProfile = true;
        this.m_Vm = new InterpolationFunction(this.m_dDeadVolumeArray);
        this.m_dtstep = this.m_dPlotXMax2 * 0.01;
        if (bHoldUpProfileFirst) {
            bBackCalculateGradientProfile = false;
            bBackCalculateFlowRateProfile = true;
        } else {
            bBackCalculateGradientProfile = true;
            bBackCalculateFlowRateProfile = false;
        }
        DecimalFormat formatter1 = new DecimalFormat("#0.000000");
        DecimalFormat formatter2 = new DecimalFormat("0.0000E0");
        DecimalFormat percentFormatter = new DecimalFormat("0.00");
        this.m_StandardIsocraticDataInterpolated = new InterpolationFunction[this.contentPane2.tmOutputModel.getRowCount()];
        int i = 0;
        while (i < this.m_StandardIsocraticDataInterpolated.length) {
            Integer iIndex = (Integer)this.m_vectCalCompounds.get(i)[0];
            this.m_StandardIsocraticDataInterpolated[i] = new InterpolationFunction(Globals.StandardIsocraticDataArray[iIndex]);
            ++i;
        }
        int iPhase = 1;
        int iIteration = 0;
        double dLastFullIterationError = 0.0;
        double dRetentionError = 0.0;
        while (true) {
            double dNum;
            String str;
            double dNum2;
            int iTimePoint;
            this.contentPane2.jlblIterationNumber.setText(Integer.valueOf(++iIteration).toString());
            dLastFullIterationError = dRetentionError;
            if (bBackCalculateFlowRateProfile) {
                iTimePoint = 0;
                while (iTimePoint < this.m_dFlowRateArray.length) {
                    double dHoldUpStep = this.m_dFlowRate / 1000.0;
                    double dHoldUpPrecision = this.m_dFlowRate / 100000.0;
                    double dMaxChangeAtOnce = this.m_dFlowRate / 20.0;
                    dRetentionError = this.goldenSectioningSearchHoldUp(iTimePoint, dHoldUpStep, dHoldUpPrecision, dMaxChangeAtOnce, bMinimizeAnglesFlowRateProfile);
                    this.updateTime(starttime);
                    dNum2 = dRetentionError / (double)this.m_vectCalCompounds.size();
                    str = dNum2 < 1.0E-4 ? formatter2.format(dNum2) : formatter1.format(dNum2);
                    this.contentPane2.jlblVariance.setText(str);
                    this.updateGraphs(true);
                    if (task.isCancelled()) {
                        return;
                    }
                    ++iTimePoint;
                }
            }
            if (bBackCalculateGradientProfile) {
                iTimePoint = 0;
                while (iTimePoint < this.m_dGradientProfileArray.length) {
                    double dPercentBStep = 0.1;
                    double dMaxChangeAtOnce = 2.0;
                    double dPercentBPrecision = 0.001;
                    dRetentionError = this.goldenSectioningSearchGradientProfile(iTimePoint, dPercentBStep, dPercentBPrecision, dMaxChangeAtOnce, bMinimizeAnglesGradientProfile);
                    this.updateTime(starttime);
                    dNum2 = dRetentionError / (double)this.m_vectCalCompounds.size();
                    str = dNum2 < 1.0E-4 ? formatter2.format(dNum2) : formatter1.format(dNum2);
                    this.contentPane2.jlblVariance.setText(str);
                    this.updateGraphs(true);
                    if (task.isCancelled()) {
                        return;
                    }
                    ++iTimePoint;
                }
            }
            String str2 = (dNum = dRetentionError / (double)this.m_vectCalCompounds.size()) == 0.0 ? "" : (dNum < 1.0E-4 ? formatter2.format(dNum) : formatter1.format(dNum));
            this.contentPane2.jlblLastVariance.setText(str2);
            int i2 = 0;
            while (i2 < this.m_dGradientProfileArray.length) {
                this.m_dGradientArrayStore[iIteration - 1][i2][0] = this.m_dGradientProfileArray[i2][0];
                this.m_dGradientArrayStore[iIteration - 1][i2][1] = this.m_dGradientProfileArray[i2][1];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.m_dFlowRateArray.length) {
                this.m_dFlowRateArrayStore[iIteration - 1][i2][0] = this.m_dFlowRateArray[i2][0];
                this.m_dFlowRateArrayStore[iIteration - 1][i2][1] = this.m_dFlowRateArray[i2][1];
                ++i2;
            }
            this.m_dRetentionErrorStore[iIteration - 1] = dRetentionError;
            if (dLastFullIterationError == 0.0) continue;
            double dPercentImprovement = (1.0 - dRetentionError / dLastFullIterationError) * 100.0;
            this.contentPane2.jlblPercentImprovement.setText(String.valueOf(percentFormatter.format(dPercentImprovement)) + "%");
            if (iPhase == 1) {
                if (!(dPercentImprovement < 1.0) || !(dPercentImprovement >= 0.0) || !(dLastFullIterationError - dRetentionError < 0.001)) continue;
                iPhase = 2;
                this.contentPane2.jlblPhase.setText("II");
                bBackCalculateGradientProfile = true;
                bBackCalculateFlowRateProfile = false;
                bMinimizeAnglesGradientProfile = true;
                bMinimizeAnglesFlowRateProfile = true;
                this.m_dtstep = this.m_dPlotXMax2 * 0.001;
                continue;
            }
            if (iPhase == 2) {
                if (!(dPercentImprovement < 2.0) || !(dPercentImprovement >= 0.0)) continue;
                iPhase = 3;
                this.contentPane2.jlblPhase.setText("III");
                if (bHoldUpProfileFirst) {
                    bBackCalculateGradientProfile = true;
                    bBackCalculateFlowRateProfile = true;
                } else {
                    bBackCalculateGradientProfile = true;
                    bBackCalculateFlowRateProfile = true;
                }
                bMinimizeAnglesGradientProfile = false;
                bMinimizeAnglesFlowRateProfile = false;
                this.m_dtstep = this.m_dPlotXMax2 * 0.001;
                continue;
            }
            if (dPercentImprovement < 2.0 && dPercentImprovement >= 0.0) break;
        }
    }

    @Override
    public void lostOwnership(Clipboard arg0, Transferable arg1) {
    }

    class CompoundSorter
    implements Comparator {
        int colIndex;

        CompoundSorter(int colIndex) {
            this.colIndex = colIndex;
        }

        public int compare(Object a, Object b) {
            Object o1 = ((Object[])a)[this.colIndex];
            Object o2 = ((Object[])b)[this.colIndex];
            if (o1 instanceof String && ((String)o1).length() == 0) {
                o1 = null;
            }
            if (o2 instanceof String && ((String)o2).length() == 0) {
                o2 = null;
            }
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            return o1.toString().compareTo(o2.toString());
        }
    }

    class Task
    extends SwingWorker<Void, Void> {
        private boolean bFlowRateProfileBackCalculationFirst = true;

        Task() {
        }

        public void setOptimizationOrder(boolean bFlowRateProfileBackCalculationFirst) {
            this.bFlowRateProfileBackCalculationFirst = bFlowRateProfileBackCalculationFirst;
        }

        @Override
        public Void doInBackground() {
            MeasureYourGradientApplet.this.backCalculate(this, this.bFlowRateProfileBackCalculationFirst);
            return null;
        }

        @Override
        public void done() {
            MeasureYourGradientApplet.this.contentPane2.jProgressBar.setIndeterminate(false);
            MeasureYourGradientApplet.this.contentPane2.jProgressBar.setStringPainted(true);
            MeasureYourGradientApplet.this.contentPane2.jbtnCalculate.setText("Copy profiles to clipboard");
            MeasureYourGradientApplet.this.contentPane2.jbtnCalculate.setActionCommand("Copy to clipboard");
            MeasureYourGradientApplet.this.contentPane2.jbtnCalculate.setEnabled(true);
            MeasureYourGradientApplet.this.contentPane2.jProgressBar.setString("Optimization complete! Now copy profiles to clipboard.");
        }
    }
}

